package org.msh.tb.bd.tbforms.indicator.detailed;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.cases.CaseItemData;
import org.msh.tb.entities.Workspace;
import org.msh.tb.indicators.core.IndicatorFilters;

import javax.persistence.EntityManager;
import java.util.List;

@Name("TBFormCasesController")
public class TBFormCasesController {

    enum Report {
        TBFORM10_BLOCK1(TBFormCasesQuery.class),
        TBFORM10_BLOCK2(TBFormCasesQuery.class),
        TBFORM10_BLOCK5A(TBForm10Block5ACasesQuery.class);

        private Class query;

        Report(Class query) {
            this.query = query;
        }

        public Class getQuery() {
            return query;
        }
    }

    private final int MAX_RESULTS_PER_QUERY = 30;

    @In
    Workspace defaultWorkspace;

    @In
    EntityManager entityManager;

    @In
    IndicatorFilters indicatorFilters;

    // Query parameters. Cell condition means the condition to filter the cases represented by a TBForm cell
    private String cellCondition;
    private Report report;
    private int page;

    // the result that will be created
    private Long resultCount;
    private List<CaseItemData> result;

    private TBFormCasesQuery query;

    /**
     * Updates the result and result count variables.
     * MUST BE called before re rendering result and result count
     */
    public void updateResults() {
        initializeQuery();
        if (query != null && cellCondition != null) {
            result = query.getResult(page, MAX_RESULTS_PER_QUERY);
            resultCount = query.getResultCount();
        }
    }

    private void initializeQuery() {
        if (report != null) {
            try {
                query = (TBFormCasesQuery) report.query
                        .getDeclaredConstructor(Workspace.class, IndicatorFilters.class, String.class, EntityManager.class)
                        .newInstance(defaultWorkspace, indicatorFilters, cellCondition, entityManager);
            } catch (Exception e) {
                query = null;
            }
        }
    }

    public List<CaseItemData> getResult() {
        return result;
    }

    public Long getResultCount() {
        return resultCount;
    }

    public String getCellCondition() {
        return cellCondition;
    }

    public void setCellCondition(String cond) {
        this.cellCondition = cond;
    }

    public void setResultCount(Long resultCount) {
        this.resultCount = resultCount;
    }

    public void setResult(List<CaseItemData> result) {
        this.result = result;
    }

    public Report getReport() {
        return report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    /**
     * @return The first count result of the current pagination to be displayed on UI
     */
    public Integer getFirstResult() {
        return page == 0 ? 1 : (page * MAX_RESULTS_PER_QUERY) + 1;
    }

    /**
     * @return The last count result of the current pagination to be displayed on UI
     */
    public Integer getLastResult() {
        // calculate last result
        Integer lastResult = MAX_RESULTS_PER_QUERY * (page + 1);

        if (lastResult > resultCount.intValue()) {
            return resultCount.intValue();
        }

        return lastResult;
    }
}
